namespace Prijateljski_trkaci
{
    public class Tacka
    {
        public double X { get; set; }
        public double Y { get; set; }
        public Tacka(double x, double y)
        {
            X = x;
            Y = y;
        }
    }
    internal class Program
    {
        public static void UnosPodataka(out int n, out Tacka[] tacke)
        {
            // Unos broja tacaka
            n = int.Parse(Console.ReadLine());

            // Inicijalizacija niza tacaka
            tacke = new Tacka[n];

            // Unos tacaka
            for (int i = 0; i < n; i++)
            {
                double[] input = Array.ConvertAll(Console.ReadLine().Split(' '), double.Parse);
                tacke[i] = new Tacka(input[0], input[1]);
            }
        }

        public static int BrojPozdravaZaDveTacke(double x1, double x2)
        {
            if (JeCeo(Math.Abs(x1 - x2) / 2.0)) return 1;

            return 0;
        }

        public static bool JeCeo(double x)
        {
            return Math.Floor(x) == x;
        }

        public static bool SePozdravljaju(double x, double y1, double y2)
        {
            return JeCeo(x) && JeCeo((double)(y1 + y2) / 2.0);
        }

        public static int BrojPozdravaZaDveTacke(Tacka tacka1, Tacka tacka2)
        {
            int ukupnoPozdrava = 0;

            if(!JeCeo(tacka1.X) && !JeCeo(tacka1.Y) && !JeCeo(tacka2.X) && !JeCeo(tacka2.Y)) return 0;

            // Kada su X ili Y kordinate jednake i celi brojevi
            if (tacka1.X == tacka2.X)
            {
                if (SePozdravljaju(tacka1.X, tacka1.Y, tacka2.Y)) ukupnoPozdrava++;
            }
            else if (tacka1.Y == tacka2.Y)
            {
                if (SePozdravljaju(tacka1.Y, tacka1.X, tacka2.X)) ukupnoPozdrava++;
            }
            else
            {
                // Kada X i Y kordinate nisu jednake, ali jesu celi brojevi
                if (JeCeo(tacka1.X) && JeCeo(tacka2.Y)) ukupnoPozdrava++;
                if (JeCeo(tacka2.X) && JeCeo(tacka1.Y)) ukupnoPozdrava++;
            }


            return ukupnoPozdrava;
        }

        //public static int UkupnoPozdrava(int n, Tacka[] tacke)
        //{
        //    int ukupnoPozdrava = 0;

        //    // Prolazak kroz sve parove tacaka
        //    for (int i = 0; i < n; i++)
        //    {
        //        for (int j = i + 1; j < n; j++)
        //        {
        //            ukupnoPozdrava += BrojPozdravaZaDveTacke(tacke[i], tacke[j]);
        //        }
        //    }

        //    return ukupnoPozdrava;
        //}

        public static int UkupnoPozdrava(int n, Tacka[] tacke)
        {
            int ukupnoPozdrava = 0;

            // Prolazak kroz sve parove tacaka
            for (int i = 0; i < n; i++)
            {
                for (int j = i + 1; j < n; j++)
                {
                    if (JeCeo(tacke[i].Y)) ukupnoPozdrava += BrojPozdravaZaDveTacke(tacke[i].X, tacke[j].X);
                }
            }

            return ukupnoPozdrava;
        }

        static void Main(string[] args)
        {
            // Unos podataka
            UnosPodataka(out int n, out Tacka[] tacke);

            Console.WriteLine(UkupnoPozdrava(n, tacke));

        }
    }
}